--[[---------------------------------------------------------------------------
	Chocolatier Two Development Toolbar: Quest Detail
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local xDialog = gDialogTable.x or 100
local yDialog = gDialogTable.y or 50

local incompleteColoring = "<font color='ee2222'>"
local completeColoring = "<font color='22ee22'>"

local self = gDialogTable.quest
if type(self) == "string" then self = LQuest:ByName(self) end

local layout = {}
local y = 0
local dy = bsgFontHeight(devPopupFont)
local w = 600

local function AddLine(text, indent, lines)
	indent = indent or 0
	lines = lines or 1
	table.insert(layout, TightText { x=indent,y=y,w=w-indent,h=dy*lines, label=text, flags=kVAlignTop+kHAlignLeft })
	y = y + dy*lines
end

-------------------------------------------------------------------------------

-- Name
local n = GetString(self.name) or "-NO NAME-"
local n = "#"..n.." ("..self.name..")"
AddLine(n)

if gSim.quest == self then
	AddLine("#<b>--- Quest Active ---</b>")
end

if self.complete then
	AddLine("#<b>--- Quest Completed ---</b>")
end

-- Summary
local s = self:SummaryText() or "-NO SUMMARY-"
AddLine("#Summary:")
AddLine("#"..s, 10, 2)

-- Starters and Enders
AddLine("#Starters:")
for _,c in ipairs(self.starter) do
	local n = GetString(c.name).. " ("..c.name..")"
	AddLine("#"..n, 10)
end

AddLine("#Enders:")
for _,c in ipairs(self.ender) do
	local n = GetString(c.name).. " ("..c.name..")"
	AddLine("#"..n, 10)
end

-- Requirements
if self.requirements and table.getn(self.requirements) > 0 then
	AddLine("#Requirements/Prerequisites:")
	for _,f in ipairs(self.requirements) do
		local label = f(true) or ""
		if not f() then label = incompleteColoring..label end
		AddLine("#"..label, 10)
	end
	
	-- Special
	if self.eligibleTime and self.eligibleTime > gSim.weeks then
		local l = incompleteColoring.."Delayed until "..bsgDate(self.eligibleTime,0).."(week "..tostring(self.eligibleTime)..")"
		AddLine("#"..l, 10)
	end
end

-- Denial
if self.denial and table.getn(self.denial) > 0 then
	AddLine("#Gifts on Denial:")
	for _,f in ipairs(self.denial) do
		local label = f(true)
		AddLine("#"..tostring(label), 10)
	end
end

-- Gifts
if self.gifts and table.getn(self.gifts) > 0 then
	AddLine("#Gifts on Acceptance:")
	for _,f in ipairs(self.gifts) do
		local label = f(true)
		AddLine("#"..tostring(label), 10)
	end
end

-- Goals
if self.goals and table.getn(self.goals) > 0 then
	AddLine("#Goals:")
	for _,f in ipairs(self.goals) do
		local label = f(true) or ""
		if not f() then label = incompleteColoring..label end
		AddLine("#"..tostring(label), 10)
	end
end

-- Rewards
if self.rewards and table.getn(self.rewards) > 0 then
	AddLine("#Rewards:")
	for _,f in ipairs(self.rewards) do
		local label = f(true) or ""
		AddLine("#"..tostring(label), 10)
	end
end

-- Follow Up
if self.followUp then
	local n = GetString(self.followUp) or "-NO NAME-"
	local n = "#Follow Up: "..n.." ("..self.followUp..")"
	AddLine(n)
end

-- Activation
if gSim.quest then
	AddLine("#Complete current quest to enable another")
else
	local label = "#Activate"
	if self.complete then label="#RE-Activate" end
	table.insert(layout, SetStyle(standardStyle))
	table.insert(layout, TextButton { x=0,y=y, name="activate", label=label,
		command=function() EnableWindow("activate", false) self:Offer() end,
	})
	y = y + ui.devButtonH
end

-------------------------------------------------------------------------------

MakeDialog
{
	AppendStyle { font=devPopupFont },
	Rectangle
	{
		x=xDialog,y=yDialog,w=200,h=200,
		inset=3, fit=true,
		Group(layout),
		
		SetStyle(standardStyle),
		TextButton { x=0,y=y, name="ok", close=true, label="ok" },		
	}
}
